package mcfall.raytracer;

/**
 * This class is used to hold a floating point value between 0.0 and 1.0; it is provided as a class to make not require us 
 * to check for valid values in several different places.  If an attempt is made to set the value associated with the object
 * to an invalid value, it is clamped at either 0 or 1.
 * @author mcfall
 *
 */
public class Intensity {
	private double value;
	
	public Intensity (double initialValue) {
		setValue (initialValue);
	}

	/**
	 * Adds the specified amount to this intensity
	 * @param amount
	 */
	public void add (double amount) {
		setValue (value+amount);
	}
	
	public double getValue() {
		return value;
	}

	protected void setValue(double value) {
		if (value < 0) {
			value = 0;
		}
		
		if (value > 1) {
			value = 1;
		}
		this.value = value;
	}
	
	public String toString () {
		return String.valueOf(value);
	}
}
